<?php
/**
* @version $Id: mod_fullmenu.php 6072 2006-12-20 02:09:09Z robs $
* @package Joomla
* @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

if (!defined( '_JOS_FULLMENU_MODULE' )) {
	/** ensure that functions are declared only once */
	define( '_JOS_FULLMENU_MODULE', 1 );

	/**
	* Full DHTML Admnistrator Menus
	* @package Joomla
	*/
	class mosFullAdminMenu {
		/**
		* Show the menu
		* @param string The current user type
		*/
		function show( $usertype='' ) {
			global $acl, $database;
			global $mosConfig_live_site, $mosConfig_enable_stats, $mosConfig_caching;

			// cache some acl checks
			$canConfig 			= $acl->acl_check( 'administration', 'config', 'users', $usertype );

			$manageTemplates 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_templates' );
			$manageTrash 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_trash' );
			$manageMenuMan 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_menumanager' );
			$manageLanguages 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_languages' );
			$installModules 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'modules', 'all' );
			$editAllModules 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'modules', 'all' );
			$installMambots 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'mambots', 'all' );
			$editAllMambots 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'mambots', 'all' );
			$installComponents 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'components', 'all' );
			$editAllComponents 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'components', 'all' );
			$canMassMail 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_massmail' );
			$canManageUsers 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_users' );

			$query = "SELECT a.id, a.title, a.name"
			. "\n FROM #__sections AS a"
			. "\n WHERE a.scope = 'content'"
			. "\n GROUP BY a.id"
			. "\n ORDER BY a.ordering"
			;
			$database->setQuery( $query );
			$sections = $database->loadObjectList();

			$menuTypes = mosAdminMenus::menutypes();
			?>
			<div id="myMenuID"></div>
			<script language="JavaScript" type="text/javascript">
			var myMenu =
			[
			<?php
		// Home Sub-Menu
	?>			[null,'Ana Sayfa','index2.php',null,'Kontrol Paneli'],
				_cmSplit,
				<?php
		// Site Sub-Menu
	?>			[null,'Site',null,null,'Site Yneticisi',
	<?php
				if ($canConfig) {
	?>				['<img src="../includes/js/ThemeOffice/config.png" />','Genel Ayarlar','index2.php?option=com_config&hidemainmenu=1',null,'Ayarlar'],
	<?php
				}
				if ($manageLanguages) {
	?>				['<img src="../includes/js/ThemeOffice/language.png" />','Lisan Yneticisi',null,null,'Lisanlari Ynet',
	  					['<img src="../includes/js/ThemeOffice/language.png" />','Site Lisanlari','index2.php?option=com_languages',null,'Lisanlari ynet'],
	   				],
	<?php
				}
	?>				['<img src="../includes/js/ThemeOffice/media.png" />','Medya Yneticisi','index2.php?option=com_media',null,'Medya Dosyalarini ynet'],
						['<img src="../includes/js/ThemeOffice/preview.png" />', 'Grnm', null, null, 'Grnm',
						['<img src="../includes/js/ThemeOffice/preview.png" />','Yeni Pencerede','<?php echo $mosConfig_live_site; ?>/index.php','_blank','<?php echo $mosConfig_live_site; ?>'],
						['<img src="../includes/js/ThemeOffice/preview.png" />','erevede','index2.php?option=com_admin&task=preview',null,'<?php echo $mosConfig_live_site; ?>'],
						['<img src="../includes/js/ThemeOffice/preview.png" />','erevede(Pozisyonlarla)','index2.php?option=com_admin&task=preview2',null,'<?php echo $mosConfig_live_site; ?>'],
					],
					['<img src="../includes/js/ThemeOffice/globe1.png" />', 'Istatistikler', null, null, 'Site istatistikleri',
	<?php
				if ($mosConfig_enable_stats == 1) {
	?>					['<img src="../includes/js/ThemeOffice/globe4.png" />', 'Tarayici, IS, Alan Adi', 'index2.php?option=com_statistics', null, 'Tarayici, IS, Alan Adi'],
	<?php
				}
	?>					['<img src="../includes/js/ThemeOffice/search_text.png" />', 'Aranan Kelimeler', 'index2.php?option=com_statistics&task=searches', null, 'Aranan Kelimeler']
					],
	<?php
				if ($manageTemplates) {
	?>				['<img src="../includes/js/ThemeOffice/template.png" />','Tema Yneticisi',null,null,'Site Temalarini degisebilirsiniz',
	  					['<img src="../includes/js/ThemeOffice/template.png" />','Site Temalari','index2.php?option=com_templates',null,'Site Temalarini degisebilirsiniz'],
	  					_cmSplit,
	  					['<img src="../includes/js/ThemeOffice/template.png" />','Ynetici Temalari','index2.php?option=com_templates&client=admin',null,'Ynetici Temasini degistirebilirsiniz'],
	  					_cmSplit,
	  					['<img src="../includes/js/ThemeOffice/template.png" />','Modl Pozisyonlari','index2.php?option=com_templates&task=positions',null,'Modl Pozisyonlari']
	  				],
	<?php
				}
				if ($manageTrash) {
	?>				['<img src="../includes/js/ThemeOffice/trash.png" />','p Yneticisi','index2.php?option=com_trash',null,'p Yneticisi'],
	<?php
				}
				if ($canManageUsers || $canMassMail) {
	?>				['<img src="../includes/js/ThemeOffice/users.png" />','ye Yneticisi','index2.php?option=com_users&task=view',null,'yeleri Ynet'],
	<?php
					}
	?>			],
	<?php
		// Menu Sub-Menu
	?>			_cmSplit,
				[null,'Menu',null,null,'Menu Management',
	<?php
				if ($manageMenuMan) {
	?>				['<img src="../includes/js/ThemeOffice/menus.png" />','Men Yneticisi','index2.php?option=com_menumanager',null,'Men Yneticisi'],
					_cmSplit,
	<?php
				}
				foreach ( $menuTypes as $menuType ) {
	?>				['<img src="../includes/js/ThemeOffice/menus.png" />','<?php echo $menuType;?>','index2.php?option=com_menus&menutype=<?php echo $menuType;?>',null,''],
	<?php
				}
	?>			],
				_cmSplit,
	<?php
		// Content Sub-Menu
	?>			[null,'Ierik',null,null,'Ierikler',
	<?php
				if (count($sections) > 0) {
	?>				['<img src="../includes/js/ThemeOffice/edit.png" />','Blmlere gre ierikler',null,null,'ierik ynetimi',
	<?php
					foreach ($sections as $section) {
						$txt = addslashes( $section->title ? $section->title : $section->name );
	?>					['<img src="../includes/js/ThemeOffice/document.png" />','<?php echo $txt;?>', null, null,'<?php echo $txt;?>',
							['<img src="../includes/js/ThemeOffice/edit.png" />', '<?php echo $txt;?> geleri', 'index2.php?option=com_content&sectionid=<?php echo $section->id;?>',null,null],
							['<img src="../includes/js/ThemeOffice/backup.png" />', '<?php echo $txt;?> Arsivleri','index2.php?option=com_content&task=showarchive&sectionid=<?php echo $section->id;?>',null,null],
							['<img src="../includes/js/ThemeOffice/add_section.png" />', '<?php echo $txt;?> Kategorileri', 'index2.php?option=com_categories&section=<?php echo $section->id;?>',null, null],
						],
	<?php
					} // foreach
	?>				],
					_cmSplit,
	<?php
				}
	?>
					['<img src="../includes/js/ThemeOffice/edit.png" />','Tm ierik geleri','index2.php?option=com_content&sectionid=0',null,'ierik gelerini ynet'],
	  				['<img src="../includes/js/ThemeOffice/edit.png" />','Sabit ierik geleri','index2.php?option=com_typedcontent',null,'ierik ynetimi'],
	  				_cmSplit,
	  				['<img src="../includes/js/ThemeOffice/add_section.png" />','Blm Yneticisi','index2.php?option=com_sections&scope=content',null,'Ierik blmlerinin ynetimi'],
					['<img src="../includes/js/ThemeOffice/add_section.png" />','Kategori Yneticisi','index2.php?option=com_categories&section=content',null,'ierik kategorilerinin ynetimi'],
					_cmSplit,
	  				['<img src="../includes/js/ThemeOffice/home.png" />','n Sayfa Yneticisi','index2.php?option=com_frontpage',null,'n Sayfa Yneticisi'],
	  				['<img src="../includes/js/ThemeOffice/edit.png" />','Arsiv Yneticisi','index2.php?option=com_content&task=showarchive&sectionid=0',null,'Arsiv Yneticisi'],
	  				['<img src="../includes/js/ThemeOffice/globe3.png" />', 'Sayfa Bilgileri', 'index2.php?option=com_statistics&task=pageimp', null, 'Sayfa Bilgileri'],
				],
	<?php
		// Components Sub-Menu
		if ($installComponents) {
	?>			_cmSplit,
				[null,'Bilesenler',null,null,'Bilesen ynetimi',
	<?php
			$query = "SELECT *"
			. "\n FROM #__components"
			. "\n WHERE name != 'frontpage'"
			. "\n AND name != 'media manager'"
			. "\n ORDER BY ordering, name"
			;
			$database->setQuery( $query );
			$comps = $database->loadObjectList();	// component list
			$subs = array();	// sub menus
			// first pass to collect sub-menu items
			foreach ($comps as $row) {
				if ($row->parent) {
					if (!array_key_exists( $row->parent, $subs )) {
						$subs[$row->parent] = array();
					}
					$subs[$row->parent][] = $row;
				}
			}
			$topLevelLimit = 19; //You can get 19 top levels on a 800x600 Resolution
			$topLevelCount = 0;
			foreach ($comps as $row) {
				if ($editAllComponents | $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'components', $row->option )) {
					if ($row->parent == 0 && (trim( $row->admin_menu_link ) || array_key_exists( $row->id, $subs ))) {
						$topLevelCount++;
						if ($topLevelCount > $topLevelLimit) {
							continue;
						}
						$name = addslashes( $row->name );
						$alt = addslashes( $row->admin_menu_alt );
						$link = $row->admin_menu_link ? "'index2.php?$row->admin_menu_link'" : "null";
						echo "\t\t\t\t['<img src=\"../includes/$row->admin_menu_img\" />','$name',$link,null,'$alt'";
						if (array_key_exists( $row->id, $subs )) {
							foreach ($subs[$row->id] as $sub) {
								echo ",\n";
								$name = addslashes( $sub->name );
								$alt = addslashes( $sub->admin_menu_alt );
								$link = $sub->admin_menu_link ? "'index2.php?$sub->admin_menu_link'" : "null";
								echo "\t\t\t\t\t['<img src=\"../includes/$sub->admin_menu_img\" />','$name',$link,null,'$alt']";
							}
						}
						echo "\n\t\t\t\t],\n";
					}
				}
			}
			if ($topLevelLimit < $topLevelCount) {
				echo "\t\t\t\t['<img src=\"../includes/js/ThemeOffice/sections.png\" />','More Components...','index2.php?option=com_admin&task=listcomponents',null,'More Components'],\n";
			}
	?>
				],
	<?php
		// Modules Sub-Menu
			if ($installModules | $editAllModules) {
	?>			_cmSplit,
				[null,'Modller',null,null,'Modl ynetimi',
	<?php
				if ($editAllModules) {
	?>				['<img src="../includes/js/ThemeOffice/module.png" />', 'Site Modlleri', "index2.php?option=com_modules", null, 'Site Modlleri'],
					['<img src="../includes/js/ThemeOffice/module.png" />', 'Ynetim Paneli Modlleri', "index2.php?option=com_modules&client=admin", null, 'Ynetim Paneli Modlleri'],
	<?php
				}
	?>			],
	<?php
			} // if ($installModules | $editAllModules)
		} // if $installComponents
		// Mambots Sub-Menu
		if ($installMambots | $editAllMambots) {
	?>			_cmSplit,
				[null,'Botlar',null,null,'Bot Ynetimi',
	<?php
			if ($editAllMambots) {
	?>				['<img src="../includes/js/ThemeOffice/module.png" />', 'Site Botlari', "index2.php?option=com_mambots", null, 'Site Botlari'],
	<?php
			}
	?>			],
	<?php
		}
	?>
	<?php
		// Installer Sub-Menu
		if ($installModules) {
	?>			_cmSplit,
				[null,'Kurulum',null,null,'Kurulumlar',
	<?php
			if ($manageTemplates) {
	?>				['<img src="../includes/js/ThemeOffice/install.png" />','Tema - Site','index2.php?option=com_installer&element=template&client=',null,'Site n yz Temasi Kurulumu'],
					['<img src="../includes/js/ThemeOffice/install.png" />','Tema - Ynetim Paneli','index2.php?option=com_installer&element=template&client=admin',null,'Site Ynetim Paneli Temasi Kurulumu'],
	<?php
			}
			if ($manageLanguages) {
	?>				['<img src="../includes/js/ThemeOffice/install.png" />','Lisan','index2.php?option=com_installer&element=language',null,'Lisan Ykle'],
					_cmSplit,
	<?php
			}
	?>				['<img src="../includes/js/ThemeOffice/install.png" />', 'Bilesen','index2.php?option=com_installer&element=component',null,'Bilesen Kur/Kaldir'],
					['<img src="../includes/js/ThemeOffice/install.png" />', 'Modl', 'index2.php?option=com_installer&element=module', null, 'Modl Kur/Kaldir'],
					['<img src="../includes/js/ThemeOffice/install.png" />', 'Bot', 'index2.php?option=com_installer&element=mambot', null, 'Bot Kur/Kaldir'],
				],
	<?php
		} // if ($installModules)
		// Messages Sub-Menu
		if ($canConfig) {
	?>			_cmSplit,
	  			[null,'Mesajlar',null,null,'Mesaj Ynetimi',
	  				['<img src="../includes/js/ThemeOffice/messaging_inbox.png" />','Gelen Kutusu','index2.php?option=com_messages',null,'zel Mesajlar'],
	  				['<img src="../includes/js/ThemeOffice/messaging_config.png" />','Ayarlar','index2.php?option=com_messages&task=config&hidemainmenu=1',null,'Ayarlar']
	  			],
	<?php
		// System Sub-Menu
		/*
	?>			_cmSplit,
	  			[null,'System',null,null,'System Management',
	  				['<img src="../includes/js/ThemeOffice/joomla_16x16.png" />', 'Version Check', 'index2.php?option=com_admin&task=versioncheck', null,'Version Check'],
	  				['<img src="../includes/js/ThemeOffice/sysinfo.png" />', 'System Info', 'index2.php?option=com_admin&task=sysinfo', null,'System Information'],
	<?php
		*/
	?>			_cmSplit,
	  			[null,'Sistem',null,null,'Sistem Ynetimi',
	  				['<img src="../includes/js/ThemeOffice/joomla_16x16.png" />', 'Srm Kontrol', 'http://www.joomla.org/latest10', '_blank','Srm Kontrol'],
	  				['<img src="../includes/js/ThemeOffice/sysinfo.png" />', 'Sistem Bilgisi', 'index2.php?option=com_admin&task=sysinfo', null,'Sistem Bilgisi'],
	<?php
	  		if ($canConfig) {
	?>
					['<img src="../includes/js/ThemeOffice/checkin.png" />', 'Genel Kontrol', 'index2.php?option=com_checkin', null,'Genel Kontrol'],
	<?php
				if ($mosConfig_caching) {
	?>				['<img src="../includes/js/ThemeOffice/config.png" />','Ierik nbellegini temizle','index2.php?option=com_admin&task=clean_cache',null,'Ierik nbellegini temizle'],
					['<img src="../includes/js/ThemeOffice/config.png" />','Tm nbellegi temizle','index2.php?option=com_admin&task=clean_all_cache',null,'Tm nbellegi temizle'],
	<?php
				}
			}
	?>			],
	<?php
				}
	?>			_cmSplit,
	<?php
		// Help Sub-Menu
	?>			[null,'Yardim','index2.php?option=com_admin&task=help',null,null]
			];
			cmDraw ('myMenuID', myMenu, 'hbr', cmThemeOffice, 'ThemeOffice');
			</script>
	<?php
		}


		/**
		* Show an disbaled version of the menu, used in edit pages
		* @param string The current user type
		*/
		function showDisabled( $usertype='' ) {
			global $acl;

			$canConfig 			= $acl->acl_check( 'administration', 'config', 'users', $usertype );
			$installModules 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'modules', 'all' );
			$editAllModules 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'modules', 'all' );
			$installMambots 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'mambots', 'all' );
			$editAllMambots 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'mambots', 'all' );
			$installComponents 	= $acl->acl_check( 'administration', 'install', 'users', $usertype, 'components', 'all' );
			$editAllComponents 	= $acl->acl_check( 'administration', 'edit', 'users', $usertype, 'components', 'all' );
			$canMassMail 		= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_massmail' );
			$canManageUsers 	= $acl->acl_check( 'administration', 'manage', 'users', $usertype, 'components', 'com_users' );

			$text = 'Menu inactive for this Page';
			?>
			<div id="myMenuID" class="inactive"></div>
			<script language="JavaScript" type="text/javascript">
			var myMenu =
			[
			<?php
		/* Home Sub-Menu */
			?>
				[null,'<?php echo 'Ana Sayfa'; ?>',null,null,'<?php echo $text; ?>'],
				_cmSplit,
			<?php
		/* Site Sub-Menu */
			?>
				[null,'<?php echo 'Site'; ?>',null,null,'<?php echo $text; ?>'
				],
			<?php
		/* Menu Sub-Menu */
			?>
				_cmSplit,
				[null,'<?php echo 'Men'; ?>',null,null,'<?php echo $text; ?>'
				],
				_cmSplit,
			<?php
		/* Content Sub-Menu */
			?>
	 			[null,'<?php echo 'Ierik'; ?>',null,null,'<?php echo $text; ?>'
				],
			<?php
		/* Components Sub-Menu */
				if ( $installComponents) {
					?>
					_cmSplit,
					[null,'<?php echo 'Bilesenler'; ?>',null,null,'<?php echo $text; ?>'
					],
					<?php
				} // if $installComponents
				?>
			<?php
		/* Modules Sub-Menu */
				if ( $installModules | $editAllModules) {
					?>
					_cmSplit,
					[null,'<?php echo 'Modller'; ?>',null,null,'<?php echo $text; ?>'
					],
					<?php
				} // if ( $installModules | $editAllModules)
				?>
			<?php
		/* Mambots Sub-Menu */
				if ( $installMambots | $editAllMambots) {
					?>
					_cmSplit,
					[null,'<?php echo 'Botlar'; ?>',null,null,'<?php echo $text; ?>'
					],
					<?php
				} // if ( $installMambots | $editAllMambots)
				?>


				<?php
		/* Installer Sub-Menu */
				if ( $installModules) {
					?>
					_cmSplit,
					[null,'<?php echo 'Kurulum'; ?>',null,null,'<?php echo $text; ?>'
						<?php
						?>
					],
					<?php
				} // if ( $installModules)
				?>
				<?php
		/* Messages Sub-Menu */
				if ( $canConfig) {
					?>
					_cmSplit,
		  			[null,'<?php echo 'Mesajlar'; ?>',null,null,'<?php echo $text; ?>'
		  			],
					<?php
				}
				?>

				<?php
		/* System Sub-Menu */
				if ( $canConfig) {
					?>
					_cmSplit,
		  			[null,'<?php echo 'Sistem'; ?>',null,null,'<?php echo $text; ?>'
					],
					<?php
				}
				?>
				_cmSplit,
				<?php
		/* Help Sub-Menu */
				?>
				[null,'<?php echo 'Yardim'; ?>',null,null,'<?php echo $text; ?>']
			];
			cmDraw ('myMenuID', myMenu, 'hbr', cmThemeOffice, 'ThemeOffice');
			</script>
			<?php
		}
	}
}
$cache =& mosCache::getCache( 'mos_fullmenu' );

$hide = intval( mosGetParam( $_REQUEST, 'hidemainmenu', 0 ) );

if ( $hide ) {
	mosFullAdminMenu::showDisabled( $my->usertype );
} else {
	mosFullAdminMenu::show( $my->usertype );
}
?>